<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('uploaded_exams', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('subscribe_id');
            $table->foreign('subscribe_id')->references('id')->on('student_subscribes')->onUpdate('cascade')->onDelete('cascade');
            $table->unsignedBigInteger('exam_id');
            $table->foreign('exam_id')->references('id')->on('exams')->onUpdate('cascade')->onDelete('cascade');
            $table->smallInteger('is_uploaded')->default(1);
            $table->smallInteger('is_check')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('uploaded_exams');
    }
};
